@echo off
REM ===============================
REM WAMP MySQL Auto Backup Script
REM Database: labdb
REM Backup retention: 30 days
REM ===============================

:: CONFIGURATION
set MYSQL_PATH=C:\wamp64\bin\mysql\mysql8.2.0\bin
set BACKUP_ROOT=D:\DBBC
set DBNAME=labdb
set USER=root
set PASSWORD=

:: DATE & TIME FORMAT (YYYY-MM-DD)
for /f "tokens=2-4 delims=/ " %%i in ('date /t') do set TODAY=%%k-%%j-%%i
for /f "tokens=1-3 delims=:." %%i in ("%time%") do set NOW=%%i-%%j-%%k

:: CREATE DAILY FOLDER
set BACKUP_DIR=%BACKUP_ROOT%\%TODAY%
if not exist "%BACKUP_DIR%" mkdir "%BACKUP_DIR%"

:: BACKUP FILE NAME
set BACKUP_FILE=%BACKUP_DIR%\%DBNAME%_%TODAY%_%NOW%.sql

:: RUN BACKUP
"%MYSQL_PATH%\mysqldump.exe" -u %USER% -p%PASSWORD% %DBNAME% > "%BACKUP_FILE%"

:: DELETE BACKUPS OLDER THAN 30 DAYS
forfiles /p "%BACKUP_ROOT%" /d -30 /c "cmd /c if @isdir==TRUE rmdir /s /q @path"

exit
